"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ScheduledVaccineSchema", {
    enumerable: true,
    get: function() {
        return ScheduledVaccineSchema;
    }
});
const _zod = require("zod");
const _referenceDataschema = require("./referenceData.schema");
const _constants = require("@tamanu/constants");
const ScheduledVaccineSchema = _zod.z.object({
    id: _zod.z.string(),
    category: _zod.z.enum(_constants.VACCINE_CATEGORIES_VALUES),
    label: _zod.z.string(),
    doseLabel: _zod.z.string(),
    weeksFromBirthDue: _zod.z.number().nullable(),
    vaccine: _referenceDataschema.ReferenceDataSchema,
    visibilityStatus: _zod.z.string()
});

//# sourceMappingURL=scheduledVaccine.schema.js.map