"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    assertReportEnabled: function() {
        return assertReportEnabled;
    },
    isReportEnabled: function() {
        return isReportEnabled;
    }
});
const _errors = require("@tamanu/errors");
const isReportEnabled = (localisation, reportId)=>{
    const disabledReports = localisation?.disabledReports || [];
    return disabledReports.includes(reportId);
};
const assertReportEnabled = (localisation, reportId)=>{
    if (isReportEnabled(localisation, reportId)) {
        throw new _errors.ForbiddenError(`Report "${reportId}" is disabled`);
    }
    return true;
};

//# sourceMappingURL=assertReportEnabled.js.map