"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    BaseSurveySchema: function() {
        return BaseSurveySchema;
    },
    SurveyWithProgramSchema: function() {
        return SurveyWithProgramSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const _programschema = require("./program.schema");
const BaseSurveySchema = _zod.z.object({
    id: _zod.z.string(),
    code: _zod.z.string().nullish(),
    name: _zod.z.string().nullish(),
    surveyType: _zod.z.enum(_constants.SURVEY_TYPES).nullish()
});
const SurveyWithProgramSchema = BaseSurveySchema.extend({
    program: _programschema.ProgramSchema
});

//# sourceMappingURL=survey.schema.js.map