import { z } from 'zod';
export declare const ProcedureSchema: z.ZodObject<{
    id: z.ZodString;
    completed: z.ZodBoolean;
    date: z.ZodString;
    endTime: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    startTime: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    note: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    completedNote: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    encounterId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    locationId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    procedureTypeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    physicianId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    anaesthetistId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    anaestheticId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    departmentId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    assistantAnaesthetistId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    timeIn: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    timeOut: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    procedureType: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    leadClinician: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type Procedure = z.infer<typeof ProcedureSchema>;
//# sourceMappingURL=procedure.schema.d.ts.map