"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientPortalApi", {
    enumerable: true,
    get: function() {
        return patientPortalApi;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _surveys = require("./surveys");
const _patientData = require("./patientData");
const _auth = require("./auth");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientPortalApi = _express.default.Router();
// Auth routes
patientPortalApi.post('/login', (0, _auth.login)({
    secret: _config.default.auth.secret
}));
patientPortalApi.post('/request-login-token', _auth.requestLoginToken);
patientPortalApi.post('/verify-registration', _auth.register);
// Portal auth middleware
patientPortalApi.use((0, _auth.patientPortalMiddleware)({
    secret: _config.default.auth.secret
}));
// Patient data routes
patientPortalApi.get('/me', _patientData.getPatient);
patientPortalApi.get('/me/ongoing-conditions', _patientData.getOngoingConditions);
patientPortalApi.get('/me/allergies', _patientData.getAllergies);
patientPortalApi.get('/me/ongoing-prescriptions', _patientData.getOngoingPrescriptions);
patientPortalApi.get('/me/vaccinations/upcoming', _patientData.getUpcomingVaccinations);
patientPortalApi.get('/me/vaccinations/administered', _patientData.getAdministeredVaccines);
patientPortalApi.get('/me/appointments/upcoming', _patientData.getUpcomingAppointments);
patientPortalApi.get('/me/procedures', _patientData.getProcedures);
patientPortalApi.get('/me/surveys/outstanding', _patientData.getOutstandingSurveys);
// Survey routes
patientPortalApi.get('/settings/:facilityId', _surveys.getSettings);
patientPortalApi.get('/survey/:surveyId', _surveys.getSurvey);
patientPortalApi.post('/surveyResponse', _surveys.createSurveyResponse);
patientPortalApi.use('/suggestions', _surveys.suggestionRoutes);

//# sourceMappingURL=routes.js.map