import { DataTypes } from 'sequelize';
export async function up(query) {
    await query.addColumn('invoice_items', 'source_record_type', {
        type: DataTypes.STRING,
        allowNull: true
    });
    await query.addColumn('invoice_items', 'source_record_id', {
        type: DataTypes.STRING,
        allowNull: true
    });
    await query.removeColumn('invoice_items', 'source_id');
}
export async function down(query) {
    await query.removeColumn('invoice_items', 'source_record_type');
    await query.removeColumn('invoice_items', 'source_record_id');
    await query.addColumn('invoice_items', 'source_id', {
        type: DataTypes.UUID,
        allowNull: true
    });
}

//# sourceMappingURL=1762151660622-UpdateInvoiceItemModelToUseRecordType.js.map