"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    // write your up migration here
    await query.createTable('imaging_type_external_codes', {
        id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.DataTypes.UUIDV4
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.DataTypes.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            defaultValue: 'current'
        },
        imaging_type_code: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        code: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false
        },
        description: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable('imaging_type_external_codes');
}

//# sourceMappingURL=1764202017939-AddImagingTypeExternalCodeTable.js.map