"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const ISO9075_DATE_TIME_FMT = 'YYYY-MM-DD HH24:MI:SS';
const alterSchemaOnly = async (query, table, field)=>{
    // Change column types from of original columns from date to string
    return query.sequelize.query(`
      ALTER TABLE ${table}
      ALTER COLUMN ${field} TYPE date_time_string;
    `);
};
const alterSchemaAndBackUpLegacyData = async (query, table, field)=>{
    const COUNTRY_TIMEZONE = _config.default?.countryTimeZone;
    if (!COUNTRY_TIMEZONE) {
        throw Error('A countryTimeZone must be configured in local.json5 for this migration to run.');
    }
    // Copy data to legacy columns for backup
    await query.sequelize.query(`
      UPDATE ${table}
      SET
          ${field}_legacy = ${field};
  `);
    // Change column types from of original columns from date to string & convert data to string
    return query.sequelize.query(`
    ALTER TABLE ${table}
    ALTER COLUMN ${field} TYPE date_time_string
    USING TO_CHAR(${field}::TIMESTAMPTZ AT TIME ZONE '${COUNTRY_TIMEZONE}', '${ISO9075_DATE_TIME_FMT}');
  `);
};
async function up(query) {
    // 1. Create legacy columns
    await query.addColumn('patient_birth_data', `time_of_birth_legacy`, {
        type: _sequelize.DataTypes.STRING
    });
    const countResult = await query.sequelize.query(`SELECT COUNT(*) FROM patient_birth_data WHERE time_of_birth IS NOT NULL;`, {
        type: _sequelize.QueryTypes.SELECT
    });
    if (parseInt(countResult[0].count, 10) === 0) {
        await alterSchemaOnly(query, 'patient_birth_data', 'time_of_birth');
    } else {
        await alterSchemaAndBackUpLegacyData(query, 'patient_birth_data', 'time_of_birth');
    }
}
async function down(query) {
    await query.changeColumn('patient_birth_data', 'time_of_birth', {
        type: _sequelize.DataTypes.STRING
    });
    await query.sequelize.query(`
      ALTER TABLE patient_birth_data
      ALTER COLUMN time_of_birth type character varying(255) USING time_of_birth_legacy;`);
    await query.removeColumn('patient_birth_data', 'time_of_birth_legacy');
}

//# sourceMappingURL=111_updatePatientBirthDataDateField.js.map