"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE PROCEDURE fhir.service_requests_resolve_upstream_encounter()
    LANGUAGE SQL
    AS $$
      UPDATE fhir.service_requests sr
      SET encounter = jsonb_build_object(
          'reference', 'Encounter/' || e.id,
          'type', 'Encounter',
          'identifier', null,
          'display', null
        )
      FROM fhir.encounters e
      WHERE true
        AND jsonb_extract_path_text(sr.encounter, 'type') = 'upstream://encounter'
        AND e.upstream_id::text = jsonb_extract_path_text(sr.encounter, 'reference')
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE PROCEDURE fhir.resolve_upstreams()
    LANGUAGE SQL
    AS $$
      CALL fhir.patients_resolve_upstream_links();
      CALL fhir.service_requests_resolve_upstream_subject();
      CALL fhir.service_requests_resolve_upstream_encounter(); 
      CALL fhir.encounters_resolve_upstream_subject();
    $$
  `);
}
async function down(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE PROCEDURE fhir.resolve_upstreams()
    LANGUAGE SQL
    AS $$
      CALL fhir.patients_resolve_upstream_links();
      CALL fhir.service_requests_resolve_upstream_subject();
      CALL fhir.encounters_resolve_upstream_subject();
    $$
`);
    await query.sequelize.query('DROP PROCEDURE fhir.service_requests_resolve_upstream_encounter');
}

//# sourceMappingURL=1690516753539-fhirResolveUpstreamForEncounterReference.js.map