"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
async function up(query) {
    await query.createTable('portal_users', {
        id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 6),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('current_timestamp', 6),
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        patient_id: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            references: {
                model: 'patients',
                key: 'id'
            }
        },
        email: {
            type: _sequelize.DataTypes.TEXT,
            allowNull: false,
            unique: true
        },
        visibility_status: {
            type: _sequelize.DataTypes.TEXT,
            defaultValue: _constants.VISIBILITY_STATUSES.CURRENT
        },
        status: {
            type: _sequelize.DataTypes.TEXT,
            defaultValue: _constants.PORTAL_USER_STATUSES.PENDING,
            allowNull: false
        }
    });
}
async function down(query) {
    await query.dropTable('portal_users');
}

//# sourceMappingURL=1752466598265-addPortalUsersTable.js.map