"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const tableName = 'user_leaves';
async function up(query) {
    await query.createTable(tableName, {
        id: {
            type: _sequelize.DataTypes.UUID,
            primaryKey: true,
            allowNull: false,
            defaultValue: _sequelize.DataTypes.UUIDV4
        },
        start_date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        end_date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        user_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        scheduled_by: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        scheduled_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: false
        },
        removed_by: {
            type: _sequelize.DataTypes.STRING,
            allowNull: true,
            references: {
                model: 'users',
                key: 'id'
            },
            onDelete: 'CASCADE'
        },
        removed_at: {
            type: _sequelize.DataTypes.DATETIMESTRING,
            allowNull: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.DataTypes.NOW
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: false,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.dropTable(tableName);
}

//# sourceMappingURL=1753264212168-createUserLeaveTable.js.map