import { Model } from '../Model';
import { type InitOptions, type Models } from '../../types/model';
import type { Procedure } from '../Procedure';
import type { InvoiceProduct } from './InvoiceProduct';
export declare class Invoice extends Model {
    id: string;
    displayId: string;
    date: string;
    status: string;
    patientPaymentStatus: string;
    insurerPaymentStatus: string;
    encounterId?: string;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildPatientSyncFilter(patientCount: number, markedForSyncPatientsTable: string): string | null;
    static buildSyncLookupQueryDetails(): Promise<{
        select: string;
        joins: string;
    }>;
    static getFullReferenceAssociations(invoicePriceListId?: string): (string | {
        model: typeof import("./InvoiceDiscount").InvoiceDiscount;
        as: string;
        include: {
            model: typeof import("..").User;
            as: string;
            attributes: string[];
        }[];
    } | {
        model: typeof import("./InvoiceInsurer").InvoiceInsurer;
        as: string;
        include: {
            model: typeof import("..").ReferenceData;
            as: string;
        }[];
    } | {
        model: typeof import("./InvoiceItem").InvoiceItem;
        as: string;
        include: ({
            model: typeof InvoiceProduct;
            as: string;
            include: Record<string, any>[];
            attributes?: undefined;
        } | {
            model: typeof import("..").User;
            as: string;
            attributes: string[];
            include?: undefined;
        } | {
            model: typeof import("./InvoiceItemDiscount").InvoiceItemDiscount;
            as: string;
            include?: undefined;
            attributes?: undefined;
        })[];
    } | {
        model: typeof import("./InvoicePayment").InvoicePayment;
        as: string;
        include: ({
            model: typeof import("..").User;
            as: string;
            include?: undefined;
        } | {
            model: typeof import("./InvoicePatientPayment").InvoicePatientPayment;
            as: string;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
            }[];
        } | {
            model: typeof import("./InvoiceInsurerPayment").InvoiceInsurerPayment;
            as: string;
            include: {
                model: typeof import("..").ReferenceData;
                as: string;
            }[];
        })[];
    })[];
    private static getInProgressInvoiceForEncounter;
    static addItemToInvoice(newItem: Procedure, encounterId: string, invoiceProduct: InvoiceProduct, orderedByUserId?: string): Promise<void>;
    static removeItemFromInvoice(removedItem: Procedure, encounterId: string): Promise<void>;
}
//# sourceMappingURL=Invoice.d.ts.map