import { z } from 'zod';
export declare const OngoingPrescriptionSchema: z.ZodObject<{
    id: z.ZodString;
    medication: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>;
    doseAmount: z.ZodOptional<z.ZodNullable<z.ZodCoercedNumber<unknown>>>;
    units: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    frequency: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    durationValue: z.ZodOptional<z.ZodNullable<z.ZodCoercedNumber<unknown>>>;
    durationUnit: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    route: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    startDate: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    endDate: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    prescriber: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>>>;
    isOngoing: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    isPrn: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    isVariableDose: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    discontinued: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    discontinuedDate: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    discontinuingReason: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    notes: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    indication: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    repeats: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
    quantity: z.ZodOptional<z.ZodNullable<z.ZodNumber>>;
}, z.core.$strip>;
export type OngoingPrescription = z.infer<typeof OngoingPrescriptionSchema>;
//# sourceMappingURL=ongoingPrescription.schema.d.ts.map