/**
 * Check whether a given string looks like a bcrypt hash.
 *
 * Bcrypt hashes start with one of the prefixes: $2a$, $2b$, or $2y$,
 * followed by a cost factor and salt segments. This heuristic avoids
 * rehashing already-hashed passwords during migrations or sync.
 */
export declare function isBcryptHash(candidate: unknown): candidate is string;
//# sourceMappingURL=password.d.ts.map