"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getJsonbPath: function() {
        return getJsonbPath;
    },
    getJsonbQueryFn: function() {
        return getJsonbQueryFn;
    }
});
const _sequelize = require("sequelize");
function getJsonbPath(path) {
    const actualPath = path.slice(1).map((step)=>step === '[]' ? '[*]' : `.${step}`);
    return `$${actualPath.join('')}`;
}
function getJsonbQueryFn(path) {
    const lastElement = path[path.length - 1];
    const pathWithoutLastElement = path.slice(0, path.length - 1);
    const jsonbPath = getJsonbPath(pathWithoutLastElement);
    // path: ['a', 'b', '[]', 'c', '[]']
    // sql: jsonb_array_elements_text(jsonb_path_query(a, '$.b[*].c'))
    if (lastElement === '[]') {
        return _sequelize.Sequelize.fn('jsonb_array_elements_text', _sequelize.Sequelize.fn('jsonb_path_query', _sequelize.Sequelize.col(path[0]), _sequelize.Sequelize.literal(`'${jsonbPath}'`)));
    }
    // path: ['a', 'b', '[]', 'c', '[]', 'd']
    // sql: jsonb_extract_path_text(jsonb_path_query(a, '$.b[*].c[*]'), 'd')
    return _sequelize.Sequelize.fn('jsonb_extract_path_text', _sequelize.Sequelize.fn('jsonb_path_query', _sequelize.Sequelize.col(path[0]), _sequelize.Sequelize.literal(`'${jsonbPath}'`)), lastElement);
}

//# sourceMappingURL=jsonb.js.map