"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceInsurancePlanItem", {
    enumerable: true,
    get: function() {
        return InvoiceInsurancePlanItem;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("../Model");
let InvoiceInsurancePlanItem = class InvoiceInsurancePlanItem extends _Model.Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            invoiceInsurancePlanId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            invoiceProductId: {
                type: _sequelize.DataTypes.TEXT,
                allowNull: false
            },
            coverageValue: {
                type: _sequelize.DataTypes.DECIMAL,
                allowNull: true
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.PULL_FROM_CENTRAL,
            indexes: [
                {
                    fields: [
                        'invoiceInsurancePlanId'
                    ]
                },
                {
                    unique: true,
                    fields: [
                        'invoiceProductId',
                        'invoiceInsurancePlanId'
                    ]
                }
            ]
        });
    }
    static initRelations(models) {
        this.belongsTo(models.InvoiceInsurancePlan, {
            foreignKey: 'invoiceInsurancePlanId',
            as: 'invoiceInsurancePlan'
        });
        this.belongsTo(models.InvoiceProduct, {
            foreignKey: 'invoiceProductId',
            as: 'product'
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=InvoiceInsurancePlanItem.js.map