import { z } from 'zod';
export declare const PatientAdditionalDataSchema: z.ZodObject<{
    id: z.ZodString;
    patientId: z.ZodString;
    placeOfBirth: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    bloodType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    primaryContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    secondaryContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    maritalStatus: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    cityTown: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    streetVillage: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    educationalLevel: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    socialMedia: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    title: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    birthCertificate: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    drivingLicense: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    passport: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    passportNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    emergencyContactName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    emergencyContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    motherId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    fatherId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    healthCenterId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    secondaryVillageId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    updatedAtByField: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>>;
    insurerPolicyNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    registeredById: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    nationalityId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    countryId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    divisionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    subdivisionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    medicalAreaId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    nursingZoneId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    settlementId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    ethnicityId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    occupationId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    religionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    patientBillingTypeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    countryOfBirthId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    insurerId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    nationality: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    country: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    division: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    subdivision: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    medicalArea: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    nursingZone: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    settlement: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    ethnicity: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    occupation: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    religion: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    patientBillingType: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    countryOfBirth: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    insurer: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export declare const PatientSchema: z.ZodObject<{
    id: z.ZodString;
    displayId: z.ZodString;
    firstName: z.ZodString;
    middleName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    lastName: z.ZodString;
    dateOfBirth: z.ZodString;
    sex: z.ZodEnum<{
        MALE: string;
        FEMALE: string;
        OTHER: string;
    }>;
    village: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export declare const PatientWithAdditionalDataSchema: z.ZodObject<{
    id: z.ZodString;
    displayId: z.ZodString;
    firstName: z.ZodString;
    middleName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    lastName: z.ZodString;
    dateOfBirth: z.ZodString;
    sex: z.ZodEnum<{
        MALE: string;
        FEMALE: string;
        OTHER: string;
    }>;
    village: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
    additionalData: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        patientId: z.ZodString;
        placeOfBirth: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        bloodType: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        primaryContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        secondaryContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        maritalStatus: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        cityTown: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        streetVillage: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        educationalLevel: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        socialMedia: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        title: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        birthCertificate: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        drivingLicense: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        passport: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        passportNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        emergencyContactName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        emergencyContactNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        motherId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        fatherId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        healthCenterId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        secondaryVillageId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        updatedAtByField: z.ZodOptional<z.ZodNullable<z.ZodRecord<z.ZodString, z.ZodAny>>>;
        insurerPolicyNumber: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        registeredById: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        nationalityId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        countryId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        divisionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        subdivisionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        medicalAreaId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        nursingZoneId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        settlementId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        ethnicityId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        occupationId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        religionId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        patientBillingTypeId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        countryOfBirthId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        insurerId: z.ZodOptional<z.ZodNullable<z.ZodString>>;
        nationality: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        country: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        division: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        subdivision: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        medicalArea: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        nursingZone: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        settlement: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        ethnicity: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        occupation: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        religion: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        patientBillingType: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        countryOfBirth: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
        insurer: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>>>;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type Patient = z.infer<typeof PatientSchema>;
export type PatientWithAdditionalData = z.infer<typeof PatientWithAdditionalDataSchema>;
//# sourceMappingURL=patient.schema.d.ts.map