import { z } from 'zod';
export declare const UpcomingVaccinationSchema: z.ZodObject<{
    scheduledVaccine: z.ZodObject<{
        id: z.ZodString;
        category: z.ZodEnum<{
            [x: string]: string;
        }>;
        label: z.ZodString;
        doseLabel: z.ZodString;
        weeksFromBirthDue: z.ZodNullable<z.ZodNumber>;
        vaccine: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>;
        visibilityStatus: z.ZodString;
    }, z.core.$strip>;
    vaccine: z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>;
    dueDate: z.ZodString;
    daysTillDue: z.ZodNumber;
    status: z.ZodEnum<{
        UNKNOWN: string;
        GIVEN: string;
        NOT_GIVEN: string;
        SCHEDULED: string;
        MISSED: string;
        DUE: string;
        UPCOMING: string;
        OVERDUE: string;
        RECORDED_IN_ERROR: string;
        HISTORICAL: string;
    }>;
}, z.core.$strip>;
export type UpcomingVaccination = z.infer<typeof UpcomingVaccinationSchema>;
//# sourceMappingURL=upcomingVaccination.schema.d.ts.map