/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

/** Statistics on Endpoint activity. */
export interface EndpointStats {
  /** Cumulative number of QUIC handshakes accepted by this Endpoint. */
  acceptedHandshakes: number
  /** Cumulative number of QUIC handshakees sent from this Endpoint. */
  outgoingHandshakes: number
  /** Cumulative number of QUIC handshakes refused on this Endpoint. */
  refusedHandshakes: number
  /** Cumulative number of QUIC handshakes ignored on this Endpoint. */
  ignoredHandshakes: number
}
export declare class EndpointKey {
  /**
   * Load a private key from a PEM-encoded PKCS#8 private key string.
   *
   * If the key is not ED25519 or ECDSA(256|384), this will error.
   */
  constructor(privateKeyPem: string)
  /** Serialize private key to PEM. */
  privateKeyPem(): string
  /** Serialize public key to PEM. */
  publicKeyPem(): string
  /** Generate a new random key pair in the default scheme. */
  static generate(): EndpointKey
  /**
   * Generate a new random key pair in the given scheme.
   *
   * The argument must be one of `ed25519`, `ecdsa256`, `ecdsa384`.
   */
  static generateFor(scheme: string): EndpointKey
  /** The validity of certificates generated by this key in seconds. */
  get validity(): number
  /**
   * Set the validity of certificates generated by this key in seconds.
   *
   * Note that changing the validity of a key once it's used in an Endpoint does nothing.
   */
  set validity(seconds: number)
  /**
   * Generate a certificate for this key.
   *
   * This is primarily used internally, but exposed for convenience if you're implementing the
   * transport yourself and don't want to bother making certificates correctly.
   *
   * Returns the PEM-encoded certificate.
   */
  makeCertificate(): string
}
/** Trust policy for peers. */
export declare class Allower {
  /**
   * Define a new peer trust policy.
   *
   * `key` is the public key of the remote peer in DER format, but in general should be
   * considered an opaque blob.
   *
   * `now` is a Unix timestamp (number of non-leap seconds since the epoch). If your trust logic
   * involves time, you should use this as basis time to make calculations consistent.
   *
   * Return `true` to allow the peer to connect (or be connected to).
   *
   * `requireClientAuth` can be set to `false` for the rare case where incoming connections that
   * cannot present a client certificate should be allowed. In that case, take care to implement
   * an additional authorisation layer to restrict connections or resource access.
   */
  constructor(allowPublicKey: (key: Buffer, now: number) => boolean, requireClientAuth?: boolean)
}
/**
 * The main entrypoint to create connections to, and accept connections from other Mushi peers.
 *
 * Generally, an application will have a single endpoint instance. This results in more optimal
 * network behaviour, and as a single endpoint can have sessions to any number of peers, and each
 * session supports many concurrent datagrams and streams, there’s little need (outside of
 * testing) for multiple endpoints.
 *
 * Note that unlike the Rust API, there's no need to install a CryptoProvider before using this.
 */
export declare class Endpoint {
  /**
   * Create and setup a Mushi peer.
   *
   * You must provide a local or unspecified address to bind the endpoint to. In most cases,
   * `[::]:0` suffices: this binds to all IP interfaces and selects a random port. Use
   * `localAddr()` to discover the randomly-assigned port.
   *
   * If `bind_to` resolves to multiple socket addresses, the first that succeeds creation of the
   * socket will be used.
   *
   * `allower` is the trust policy for remote peers: incoming (client certificate) and outgoing
   * (server certificate) peers will have their public key extracted and checked by the
   * `Allower` instance.
   *
   * `cc` is the congestion control strategy for the QUIC state machine. One of `cubic` ([RFC
   * 8312]), `newreno` ([RFC 6582]), or `bbr` ([IETF Draft]]. Defaults to `cubic`.
   *
   * [RFC 8312]: https://datatracker.ietf.org/doc/html/rfc8312
   * [RFC 6582]: https://datatracker.ietf.org/doc/html/rfc6582
   * [IETF Draft]: https://datatracker.ietf.org/doc/draft-ietf-ccwg-bbr/02/
   */
  constructor(bindTo: string, key: EndpointKey, allower: Allower, cc?: string)
  /** Get the local address the underlying socket is bound to. */
  localAddr(): string
  /** Get the number of connections (≈sessions) that are currently open. */
  openConnections(): number
  /** Get QUIC activity stats. */
  stats(): EndpointStats
  /**
   * Wait for all sessions on the endpoint to be cleanly shut down.
   *
   * Waiting for this condition before exiting ensures that a good-faith effort is made to
   * notify peers of recent session closes, whereas exiting immediately could force them to wait
   * out the idle timeout period.
   *
   * Does not proactively close existing sessions or cause incoming sessions to be rejected.
   * Consider calling `session.close()` if that is desired.
   */
  waitIdle(): Promise<void>
  /** Connect to a peer. */
  connect(addrs: string): Promise<Session>
  /**
   * Accept an incoming session.
   *
   * Using this is a bit un-JS-y. Conceptually, it's an async iterator which may throw at each
   * call, and should be stopped once the function successfully returns `null`. A generator like
   * this may be used to wrap the call more ergonomically:
   *
   * ```js
   * async function* accept() {
   *     while (true) {
   *         try {
   *             const session = await endpoint.accept();
   *             if (!session) break; // endpoint is closed
   *             yield [null, session];
   *         } catch (err) {
   *             yield [err, null];
   *         }
   *     }
   * }
   *
   * for await (const [err, session] of accept()) {
   *     //
   * }
   * ```
   */
  accept(): Promise<Session | null>
}
/**
 * A Session, able to accept/create streams and send/recv datagrams.
 *
 * If all references to a session have been dropped, then the session will be automatically
 * closed with a `code` of 0 and an empty reason. You can also close the session explicitly by
 * calling `session.close()`.
 *
 * Closing the session immediately sends a `CONNECTION_CLOSE` frame and then abandons efforts to
 * deliver data to the peer. Upon receiving a `CONNECTION_CLOSE` frame, the peer may drop any
 * stream data not yet delivered to the application. `session.close()` describes in more detail
 * how to gracefully close a session without losing application data.
 */
export declare class Session {
  /**
   * The public key of the remote peer.
   *
   * This may be unavailable if `requireClientAuth` was set to `false` in the `Allower`.
   */
  peerKey(): Buffer | null
  /** The maximum size of a datagram that can be sent. */
  maxDatagramSize(): Promise<number>
  /**
   * Wait until the peer creates a new unidirectional stream.
   *
   * Will error if the session has been closed.
   */
  acceptUni(): Promise<RecvStream>
  /** Wait until the peer creates a new bidirectional stream. */
  acceptBi(): Promise<BidiStream>
  /**
   * Open a new bidirectional stream.
   *
   * May wait when there are too many concurrent streams.
   */
  openBi(): Promise<BidiStream>
  /**
   * Open a new unidirectional stream.
   *
   * May wait when there are too many concurrent streams.
   */
  openUni(): Promise<SendStream>
  /**
   * Send an unreliable datagram over the network.
   *
   * QUIC datagrams may be dropped for any reason, including (non-exhaustive):
   *
   * - Network congestion
   * - Random packet loss
   * - Payload is larger than `max_datagram_size()`
   * - Peer is not receiving datagrams
   * - Peer has too many outstanding datagrams
   */
  sendDatagram(payload: Buffer): void
  /** Receive a datagram over the network. */
  recvDatagram(): Promise<Buffer>
  /**
   * Close the session immediately.
   *
   * Pending operations will fail immediately with a `LocallyClosed` error. No more data is sent
   * to the peer beyond a `CONNECTION_CLOSE` frame, and the peer may drop buffered data upon
   * receiving the `CONNECTION_CLOSE` frame.
   *
   * `code` and `reason` are not interpreted, and are provided directly to the peer.
   *
   * `reason` will be truncated to fit in a single packet with overhead; to improve odds that it
   * is preserved in full, it should be kept under 1KiB.
   *
   * # Gracefully closing a session
   *
   * Only the peer last receiving application data can be certain that all data is delivered.
   * The only reliable action it can then take is to close the session, potentially with a
   * custom error code. The delivery of the final `CONNECTION_CLOSE` frame is very likely if
   * both endpoints stay online long enough, and `endpoint.wait_idle()` can be used to provide
   * sufficient time. Otherwise, the remote peer will time out the session after 30 seconds.
   *
   * The sending side can not guarantee all stream data is delivered to the remote application.
   *
   * It only knows the data is delivered to the QUIC stack of the remote endpoint. Once the
   * local side sends a `CONNECTION_CLOSE` frame, the remote endpoint may drop any data it
   * received but is as yet undelivered to the application, including data that was acknowledged
   * as received to the local endpoint.
   */
  close(code: number, reason: string): void
  /**
   * Wait until the connection is closed.
   *
   * Returns `null` if the connection was closed locally, and a string if the connection
   * was closed by a peer (e.g. with `close()`). Throws for other unexpected close reasons.
   */
  closed(): Promise<string | null>
}
/**
 * A handle to a QUIC receive stream.
 *
 * It's important to never call methods on this object concurrently, ie not to do two reads, or to
 * call `stop()` while reading the stream in an overlapping async context. The stream has an
 * internal mutex (lock), and overlapping accesses will introduce undesirable contention.
 */
export declare class RecvStream {
  /**
   * Read the next chunk of data with the provided maximum size.
   *
   * Returns `null` if there's nothing more to read (the stream is closed).
   */
  read(max: number): Promise<Buffer | null>
  /**
   * Read some data into the provided buffer.
   *
   * Returns the number of bytes read, or `null` if the stream is closed.
   * Make sure to differentiate between `0` and `null`.
   */
  readBuf(buf: Buffer): Promise<number | null>
  /** Send a `STOP_SENDING` QUIC code. */
  stop(code: number): Promise<void>
}
/**
 * A handle to a QUIC send stream.
 *
 * It's important to never call methods on this object concurrently, ie not to do two writes, or
 * to call `setPriority()` while writing to the stream in an overlapping async context. The stream
 * has an internal mutex (lock), and overlapping accesses will introduce undesirable contention.
 */
export declare class SendStream {
  /** Write the entire buffer to the stream. */
  readBuf(buf: Buffer): Promise<void>
}
/**
 * Return value of `accept_bi()` and `open_bi()`.
 *
 * This can be used to obtain (once) the recv and send streams.
 */
export declare class BidiStream {
  /**
   * Obtain the recv stream.
   *
   * May only be called once. After that, it will return null.
   */
  takeRecv(): RecvStream | null
  /**
   * Obtain the send stream.
   *
   * May only be called once. After that, it will return null.
   */
  takeSend(): SendStream | null
}
