import type { LoggerType } from './TamanuApi';
export interface BaseFetchOptions extends RequestInit {
    fetch?: typeof fetch;
    timeout?: number | false;
}
export interface ResponseError {
    name: string;
    message: string;
}
export interface ResponseErrorData {
    error?: ResponseError;
    [key: string]: any;
}
export declare function fetchOrThrowIfUnavailable(url: string, { fetch: fetchFn, timeout, ...config }?: BaseFetchOptions): Promise<Response>;
export declare function getResponseErrorSafely(response: Response, logger?: LoggerType): Promise<ResponseErrorData>;
