"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    PATIENT_DEATH_FULL_SCHEMA: function() {
        return PATIENT_DEATH_FULL_SCHEMA;
    },
    PATIENT_DEATH_PARTIAL_SCHEMA: function() {
        return PATIENT_DEATH_PARTIAL_SCHEMA;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const yesNoUnknown = _yup.string().lowercase().oneOf([
    'yes',
    'no',
    'unknown'
]);
const yesNo = _yup.string().lowercase().oneOf([
    'yes',
    'no'
]);
const PATIENT_DEATH_PARTIAL_SCHEMA = _yup.object().shape({
    clinicianId: _yup.string().required(),
    timeOfDeath: _yup.date().required()
});
const PATIENT_DEATH_FULL_SCHEMA = _yup.object().shape({
    ageOfMother: _yup.number().nullable(),
    antecedentCause1: _yup.string().nullable(),
    antecedentCause1Interval: _yup.number().default(0).nullable(),
    antecedentCause2: _yup.string().nullable(),
    antecedentCause2Interval: _yup.number().default(0).nullable(),
    antecedentCause3: _yup.string().nullable(),
    antecedentCause3Interval: _yup.number().default(0).nullable(),
    birthWeight: _yup.number().nullable(),
    causeOfDeath: _yup.string().required(),
    causeOfDeathInterval: _yup.number().default(0).nullable(),
    clinicianId: _yup.string().required(),
    deathWithin24HoursOfBirth: yesNo,
    facilityId: _yup.string().nullable(),
    fetalOrInfant: yesNo.default('no'),
    lastSurgeryDate: _yup.date().nullable(),
    lastSurgeryReason: _yup.string().nullable(),
    mannerOfDeath: _yup.string().required(),
    mannerOfDeathDate: _yup.date().nullable(),
    mannerOfDeathLocation: _yup.string().nullable(),
    mannerOfDeathOther: _yup.string().nullable(),
    motherExistingCondition: _yup.string().nullable(),
    numberOfCompletedPregnancyWeeks: _yup.number().nullable(),
    numberOfHoursSurvivedSinceBirth: _yup.number().nullable(),
    otherContributingConditions: _yup.array().of(_yup.object()).nullable(),
    outsideHealthFacility: _yup.boolean().default(false).nullable(),
    pregnancyContribute: yesNoUnknown,
    pregnant: yesNoUnknown,
    stillborn: yesNoUnknown,
    surgeryInLast4Weeks: yesNoUnknown,
    timeOfDeath: _yup.date().required()
});

//# sourceMappingURL=patientDeathValidationSchema.js.map