"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    allowListMiddleware: function() {
        return allowListMiddleware;
    },
    suggestionRoutes: function() {
        return suggestionRoutes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _index = require("@tamanu/shared/services/suggestions/index");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const suggestionRoutes = _express.default.Router();
const allowListMiddleware = (names)=>(req, res, next)=>{
        const firstSegment = (req.path || '').replace(/^\//, '').split('/')[0];
        if (!names.includes(firstSegment)) {
            res.status(404).end();
            return;
        }
        next();
    };
suggestionRoutes.use('/', allowListMiddleware(_constants.PORTAL_SUGGESTER_ALLOW_LIST), _index.suggestions);

//# sourceMappingURL=suggestionRoutes.js.map