"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return _default;
    }
});
const Sequelize = require('sequelize');
const _default = {
    up: async (query)=>{
        await query.createTable('user_feature_flags_cache', {
            id: {
                type: Sequelize.STRING,
                defaultValue: Sequelize.UUIDV4,
                allowNull: false,
                primaryKey: true
            },
            featureFlags: {
                type: Sequelize.STRING,
                allowNull: false
            },
            user_id: {
                type: Sequelize.STRING,
                references: {
                    model: 'users',
                    key: 'id'
                }
            }
        }, {});
    },
    down: async (query)=>{
        await query.dropTable('user_feature_flags_cache');
    }
};

//# sourceMappingURL=015_addUserFeatureFlagsCacheTable.js.map