"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
const tableName = 'user_leaves';
async function up(query) {
    await query.removeColumn(tableName, 'removed_at');
    await query.removeColumn(tableName, 'removed_by');
    await query.removeColumn(tableName, 'scheduled_at');
    await query.removeColumn(tableName, 'scheduled_by');
}
async function down(query) {
    await query.addColumn(tableName, 'removed_at', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: true
    });
    await query.addColumn(tableName, 'removed_by', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true,
        references: {
            model: 'users',
            key: 'id'
        },
        onDelete: 'CASCADE'
    });
    await query.addColumn(tableName, 'scheduled_at', {
        type: _sequelize.DataTypes.DATETIMESTRING,
        allowNull: false
    });
    await query.addColumn(tableName, 'scheduled_by', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false,
        references: {
            model: 'users',
            key: 'id'
        },
        onDelete: 'CASCADE'
    });
}

//# sourceMappingURL=1756955166855-removeColumnsFromUserLeavesTable.js.map