"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    SettingsCache: function() {
        return SettingsCache;
    },
    settingsCache: function() {
        return settingsCache;
    }
});
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
let SettingsCache = class SettingsCache {
    getCacheKey(facilityId) {
        return facilityId ?? 'central';
    }
    getAllSettings(facilityId) {
        const key = this.getCacheKey(facilityId);
        // If cache is expired, reset it.
        if (!this.isValid(facilityId)) {
            this.reset(facilityId);
        }
        return this.allSettingsCache.get(key) || null;
    }
    setAllSettings(value, facilityId) {
        const key = this.getCacheKey(facilityId);
        this.allSettingsCache.set(key, value);
        // Calculate expiration timestamp based on ttl
        this.expirationTimestamps.set(key, Date.now() + this.ttl);
    }
    reset(facilityId) {
        if (facilityId === undefined) {
            this.allSettingsCache.clear();
            this.expirationTimestamps.clear();
        } else {
            // Clear specific facility cache
            const key = this.getCacheKey(facilityId);
            this.allSettingsCache.delete(key);
            this.expirationTimestamps.delete(key);
        }
    }
    isValid(facilityId) {
        const key = this.getCacheKey(facilityId);
        const expirationTimestamp = this.expirationTimestamps.get(key);
        return expirationTimestamp && Date.now() < expirationTimestamp;
    }
    constructor(){
        // Map of facilityId (or 'central' for no facility) to cache objects
        _define_property(this, "allSettingsCache", new Map());
        // Map of facilityId to expiration timestamps
        _define_property(this, "expirationTimestamps", new Map());
        // TTL in milliseconds
        _define_property(this, "ttl", 60000);
    }
};
const settingsCache = new SettingsCache();

//# sourceMappingURL=settingsCache.js.map