"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "settingsReaderMiddleware", {
    enumerable: true,
    get: function() {
        return settingsReaderMiddleware;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _reader = require("../reader");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const settingsReaderMiddleware = (req, _res, next)=>{
    const { models } = req;
    const { serverFacilityId, serverFacilityIds } = _config.default;
    const isFacility = serverFacilityId || serverFacilityIds;
    const facilityIds = isFacility && (serverFacilityId ? [
        serverFacilityId
    ] : serverFacilityIds);
    try {
        // n.b. facilityId will not be defined if
        // - this is a central server; or
        // - this is a route that is pre-auth
        // in which case only settings that are not facility specific will be available
        if (facilityIds) {
            req.settings = facilityIds.reduce((acc, facilityId)=>({
                    ...acc,
                    [facilityId]: new _reader.ReadSettings(models, facilityId)
                }), {});
        } else {
            req.settings = new _reader.ReadSettings(models);
        }
        next();
    } catch (e) {
        next(e);
    }
};

//# sourceMappingURL=settingsReaderMiddleware.js.map