"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "defineDbNotifier", {
    enumerable: true,
    get: function() {
        return defineDbNotifier;
    }
});
const _pgnotify = /*#__PURE__*/ _interop_require_default(require("pg-notify"));
const _hook = require("./hook");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const CHANNEL_TO_HOOK = {
    [_constants.NOTIFY_CHANNELS.TABLE_CHANGED]: _constants.BACKEND_HOOKS.DATABASE_TABLE_CHANGED,
    [_constants.NOTIFY_CHANNELS.MATERIALIZED_VIEW_REFRESHED]: _constants.BACKEND_HOOKS.DATABASE_MATERIALIZED_VIEW_REFRESHED
};
const defineDbNotifier = async (config, channels = [])=>{
    const pubsub = new _pgnotify.default({
        host: config.host,
        port: config.port,
        user: config.username,
        password: config.password,
        database: config.database
    });
    await pubsub.connect();
    // Define hooks dynamically based on channels
    const hooks = {};
    channels.forEach((channel)=>{
        hooks[channel] = (0, _hook.defineHook)(CHANNEL_TO_HOOK[channel]);
    });
    // Subscribe to each channel and trigger the respective hook
    await Promise.all(channels.map((channel)=>pubsub.on(channel, (payload)=>hooks[channel].trigger(payload))));
    const close = async ()=>{
        await pubsub.close();
    };
    // Return an object with the dynamically created 'on' functions and the close function
    const listeners = channels.reduce((acc, channel)=>{
        acc[channel] = hooks[channel].on;
        return acc;
    }, {});
    return {
        listeners,
        close
    };
};

//# sourceMappingURL=dbNotifier.js.map