"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    FHIR_COUNT_CONFIG_DEFAULT: function() {
        return FHIR_COUNT_CONFIG_DEFAULT;
    },
    RESULT_PARAMETERS: function() {
        return RESULT_PARAMETERS;
    },
    RESULT_PARAMETER_NAMES: function() {
        return RESULT_PARAMETER_NAMES;
    },
    normaliseParameter: function() {
        return normaliseParameter;
    },
    normaliseParameters: function() {
        return normaliseParameters;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _constants = require("@tamanu/constants");
const _schemata = require("./schemata");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
// Extract config values with a fallback
// FHIR_COUNT_CONFIG_MAX needs to be at least as big as the default
const FHIR_COUNT_CONFIG = _config.default?.integrations?.fhir?.parameters?._count || {};
const FHIR_COUNT_CONFIG_DEFAULT = FHIR_COUNT_CONFIG?.default || _constants.FHIR_MAX_RESOURCES_PER_PAGE;
const FHIR_COUNT_CONFIG_MAX = Math.max(FHIR_COUNT_CONFIG?.max || 0, FHIR_COUNT_CONFIG_DEFAULT);
if (_config.default?.integrations?.fhir?.enabled && FHIR_COUNT_CONFIG_DEFAULT > FHIR_COUNT_CONFIG?.max) {
    // eslint-disable-next-line no-console
    console.warn('FHIR _count config default value is bigger than the max.');
}
function normaliseParameter([key, param], overrides = {}) {
    const defaultSchema = _schemata.DEFAULT_SCHEMA_FOR_TYPE[param.type];
    const norm = {
        path: [
            [
                key
            ]
        ],
        sortable: true,
        parameterSchema: typeof param.parameterSchema === 'function' ? param.parameterSchema(defaultSchema || _yup) : defaultSchema,
        ...param,
        ...overrides
    };
    if (param.type === _constants.FHIR_SEARCH_PARAMETERS.TOKEN && !norm.tokenType) {
        norm.tokenType = _constants.FHIR_SEARCH_TOKEN_TYPES.CODING;
    }
    if (param.type === _constants.FHIR_SEARCH_PARAMETERS.DATE && !norm.datePrecision) {
        norm.datePrecision = _constants.FHIR_DATETIME_PRECISION.SECONDS;
    }
    return [
        key,
        norm
    ];
}
const RESULT_PARAMETERS = {
    _total: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _yup.string().oneOf([
            'none',
            'estimate',
            'accurate'
        ])
    },
    _summary: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _yup.string().oneOf([
            'true',
            'text',
            'data',
            'count',
            'false'
        ])
    },
    _count: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _yup.number().integer().min(0) // equivalent to _summary=count
        .max(FHIR_COUNT_CONFIG_MAX).default(FHIR_COUNT_CONFIG_DEFAULT)
    },
    _page: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _yup.number().integer().min(0).default(0)
    },
    _include: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _schemata.INCLUDE_SCHEMA
    },
    _revinclude: {
        type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
        parameterSchema: _schemata.INCLUDE_SCHEMA
    }
};
const RESULT_PARAMETER_NAMES = [
    '_sort',
    ...Object.keys(RESULT_PARAMETERS)
];
function sortParameter(sortableParameters) {
    return {
        _sort: {
            type: _constants.FHIR_SEARCH_PARAMETERS.SPECIAL,
            parameterSchema: _yup.object().transform(function sortParse(value, originalValue) {
                if (this.isType(value)) return value;
                if (originalValue.startsWith('-')) {
                    return {
                        order: 'DESC',
                        by: originalValue.replace(/^-/, '')
                    };
                }
                return {
                    order: 'ASC',
                    by: originalValue
                };
            }).shape({
                order: _yup.string().oneOf([
                    'ASC',
                    'DESC'
                ]).required(),
                by: _yup.string().oneOf([
                    '_score',
                    ...sortableParameters.map(([k])=>k)
                ], '_sort key is not an allowed value').required()
            }).noUnknown()
        }
    };
}
const cache = new Map();
function normaliseParameters(FhirResource) {
    const cacheKey = FhirResource.fhirName;
    if (!cacheKey) {
        throw new Error('DEV: not a proper Resource');
    }
    if (cache.has(cacheKey)) {
        return cache.get(cacheKey);
    }
    const resourceParameters = Object.entries(FhirResource.searchParameters()).map(normaliseParameter);
    // eslint-disable-next-line no-unused-vars
    const sortableParameters = resourceParameters.filter(([_, v])=>v.sortable);
    const resultParameters = Object.entries({
        ...sortParameter(sortableParameters),
        ...RESULT_PARAMETERS
    }).map((param)=>normaliseParameter(param, {
            path: [],
            sortable: false
        }));
    const parameters = new Map([
        ...resourceParameters,
        ...resultParameters
    ]);
    cache.set(cacheKey, parameters);
    return parameters;
}

//# sourceMappingURL=parameters.js.map