"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "EncounterDetails", {
    enumerable: true,
    get: function() {
        return EncounterDetails;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _DataSection = require("./DataSection");
const _DataItem = require("./DataItem");
const _patientAccessors = require("../../patientAccessors");
const _Layout = require("../Layout");
const _HorizontalRule = require("./HorizontalRule");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const EncounterDetails = ({ encounter })=>{
    const { location, department } = encounter || {};
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: "Encounter details",
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Facility",
        value: location?.facility?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Location",
        value: (0, _patientAccessors.getLocationName)(encounter)
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: "Department",
        value: department?.name
    }))), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, {
        width: "2px"
    }));
};

//# sourceMappingURL=EncounterDetails.js.map