"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
async function up(query) {
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.op_inverse_regex(regex text, value text)
    RETURNS boolean
    LANGUAGE SQL
    IMMUTABLE PARALLEL SAFE
    AS $$
      SELECT value ~ regex
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.op_inverse_not_regex(regex text, value text)
    RETURNS boolean
    LANGUAGE SQL
    IMMUTABLE PARALLEL SAFE
    AS $$
      SELECT value !~ regex
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.op_inverse_regexi(regex text, value text)
    RETURNS boolean
    LANGUAGE SQL
    IMMUTABLE PARALLEL SAFE
    AS $$
      SELECT value ~* regex
    $$
  `);
    await query.sequelize.query(`
    CREATE OR REPLACE FUNCTION fhir.op_inverse_not_regexi(regex text, value text)
    RETURNS boolean
    LANGUAGE SQL
    IMMUTABLE PARALLEL SAFE
    AS $$
      SELECT value !~* regex
    $$
  `);
    await query.sequelize.query(`
    CREATE OPERATOR fhir.<~ (
      FUNCTION = fhir.op_inverse_regex,
      LEFTARG = text,
      RIGHTARG = text,
      NEGATOR = OPERATOR(fhir.<!~),
      RESTRICT = eqsel
    );
  `);
    await query.sequelize.query(`
    CREATE OPERATOR fhir.<!~ (
      FUNCTION = fhir.op_inverse_not_regex,
      LEFTARG = text,
      RIGHTARG = text,
      NEGATOR = OPERATOR(fhir.<~),
      RESTRICT = neqsel
    );
  `);
    await query.sequelize.query(`
    CREATE OPERATOR fhir.<~* (
      FUNCTION = fhir.op_inverse_regexi,
      LEFTARG = text,
      RIGHTARG = text,
      NEGATOR = OPERATOR(fhir.<!~*),
      RESTRICT = eqsel
    );
  `);
    await query.sequelize.query(`
    CREATE OPERATOR fhir.<!~* (
      FUNCTION = fhir.op_inverse_not_regexi,
      LEFTARG = text,
      RIGHTARG = text,
      NEGATOR = OPERATOR(fhir.<~*),
      RESTRICT = neqsel
    );
  `);
}
async function down(query) {
    await query.sequelize.query('DROP OPERATOR fhir.<!~* (text, text)');
    await query.sequelize.query('DROP OPERATOR fhir.<~* (text, text)');
    await query.sequelize.query('DROP OPERATOR fhir.<!~ (text, text)');
    await query.sequelize.query('DROP OPERATOR fhir.<~ (text, text)');
    await query.sequelize.query('DROP FUNCTION fhir.op_inverse_regex');
    await query.sequelize.query('DROP FUNCTION fhir.op_inverse_not_regex');
    await query.sequelize.query('DROP FUNCTION fhir.op_inverse_regexi');
    await query.sequelize.query('DROP FUNCTION fhir.op_inverse_not_regexi');
}

//# sourceMappingURL=117_fhirInverseRegexOperators.js.map