import type { Logger } from 'winston';
import * as z from 'zod';
import type { Subject } from '@casl/ability';
import type { ReadSettings } from '@tamanu/settings';
import { Model } from './Model';
import type { Facility } from './Facility';
import type { Device } from './Device';
import type { InitOptions, ModelProperties, Models } from '../types/model';
export declare class User extends Model {
    id: string;
    displayId?: string;
    email: string;
    password?: string;
    displayName: string;
    role: string;
    phoneNumber?: string;
    visibilityStatus: string;
    facilities: Facility[];
    deviceRegistrationQuota: number;
    static SALT_ROUNDS: number;
    static hashPassword(pw: string): Promise<string>;
    static isPasswordHashed(password: string): boolean;
    static getSystemUser(): Promise<User | null>;
    forResponse(): any;
    setPassword(pw: string): Promise<void>;
    static sanitizeForInsert(values: any): Promise<any>;
    static update(values: any, options: any): Promise<any>;
    static create(values: any, ...args: any[]): Promise<any>;
    static bulkCreate(records: any[], ...args: any[]): Promise<any>;
    static upsert(values: any, ...args: any[]): Promise<any>;
    static getForAuthByEmail(email: string): Promise<User | null>;
    static initModel({ primaryKey, ...options }: InitOptions): void;
    static initRelations(models: Models): void;
    static buildSyncFilter(): null;
    static getFullReferenceAssociations(): ({
        model: typeof import("./UserDesignation").UserDesignation;
        as: string;
        include: {
            model: typeof import("./ReferenceData").ReferenceData;
            as: string;
        };
        attributes?: undefined;
    } | {
        model: typeof Facility;
        as: string;
        attributes: string[];
        include?: undefined;
    })[];
    static buildSyncLookupQueryDetails(): Promise<null>;
    isSuperUser(): boolean;
    checkPermission(action: string, subject: Subject, field?: string): Promise<void>;
    hasPermission(action: string, subject: Subject, field?: string): Promise<boolean>;
    canSync(facilityIds: string[], { settings }: {
        settings: any;
    }): Promise<boolean>;
    allowedFacilities(): Promise<"ALL" | {
        id: string;
        name: string;
    }[]>;
    allowedFacilityIds(): Promise<string[] | "ALL">;
    canAccessFacility(id: string): Promise<boolean>;
    static filterAllowedFacilities(allowedFacilities: string | ModelProperties<Facility>[], facilityIds: string[]): Promise<{
        id: string;
        name: string;
    }[]>;
    static readonly LoginPayload: z.ZodObject<{
        email: z.ZodEmail;
        password: z.ZodString;
        facilityIds: z.ZodOptional<z.ZodArray<z.ZodString>>;
        deviceId: z.ZodOptional<z.ZodString>;
        scopes: z.ZodOptional<z.ZodArray<z.ZodEnum<{
            readonly SYNC_CLIENT: "sync_client";
        }>>>;
        clientHeader: z.ZodOptional<z.ZodString>;
    }, z.core.$strip>;
    static loginFromCredential(payload: Record<string, any>, { log, settings, tokenSecret, tokenIssuer, tokenDuration }: LoginContext): Promise<LoginReturn>;
    static loginFromToken(token: string, { tokenSecret, tokenIssuer }: LoginContext): Promise<LoginReturn>;
    static loginFromAuthorizationHeader(header: string | undefined | null, context: LoginContext): Promise<LoginReturn>;
}
export interface LoginContext {
    log: Logger;
    settings: ReadSettings;
    tokenDuration: number;
    tokenIssuer: string;
    tokenSecret: string;
}
export interface LoginReturn {
    token: string;
    user: User;
    device?: Device;
    facility?: Facility;
    internalClient?: boolean;
    settings?: {
        [key: string]: string | number | object;
    };
}
//# sourceMappingURL=User.d.ts.map