"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    Box: function() {
        return Box;
    },
    CertificateContent: function() {
        return CertificateContent;
    },
    CertificateFooter: function() {
        return CertificateFooter;
    },
    CertificateHeader: function() {
        return CertificateHeader;
    },
    CertificateLogo: function() {
        return CertificateLogo;
    },
    Col: function() {
        return Col;
    },
    FixedFooter: function() {
        return FixedFooter;
    },
    FixedHeader: function() {
        return FixedHeader;
    },
    LightDivider: function() {
        return LightDivider;
    },
    Logo: function() {
        return Logo;
    },
    PageBreakPadding: function() {
        return PageBreakPadding;
    },
    Row: function() {
        return Row;
    },
    Signature: function() {
        return Signature;
    },
    SigningImage: function() {
        return SigningImage;
    },
    VDSImage: function() {
        return VDSImage;
    },
    Watermark: function() {
        return Watermark;
    },
    styles: function() {
        return styles;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Text = require("../pdf/Text");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const certificateMargins = '0 18px';
const styles = _renderer.StyleSheet.create({
    page: {
        position: 'relative',
        padding: '30 30 0 30',
        color: '#222222'
    },
    logo: {
        position: 'absolute',
        top: 35,
        left: 25,
        width: 70
    },
    row: {
        flexDirection: 'row',
        flexWrap: 'wrap'
    },
    col: {
        width: '50%'
    },
    box: {
        marginBottom: 30
    },
    signature: {
        flexDirection: 'row',
        marginBottom: 20
    },
    signatureText: {
        width: 100
    },
    line: {
        width: 300,
        borderBottomColor: 'black',
        borderBottomStyle: 'solid'
    },
    signingImage: {
        width: '100%'
    },
    watermarkContainer: {
        position: 'absolute',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        minWidth: '100%',
        minHeight: '100%',
        maxHeight: '100vh',
        maxWidth: '100vw',
        backgroundColor: '#aaaaaa',
        opacity: 0.05,
        flexDirection: 'row',
        justifyContent: 'center',
        alignItems: 'center'
    },
    watermarkImage: {
        objectFit: 'contain'
    },
    vds: {
        position: 'relative',
        top: -30,
        width: 140
    },
    certificateLogo: {
        position: 'absolute',
        top: 0,
        left: 0,
        height: 60,
        width: 120,
        objectFit: 'contain',
        objectPosition: 'top left'
    },
    certificateHeader: {
        margin: 0
    },
    certificateFooter: {
        margin: certificateMargins
    },
    certificateContent: {
        margin: certificateMargins
    },
    fixedHeader: {
        position: 'absolute',
        top: 25,
        right: 50
    },
    fixedFooter: {
        position: 'absolute',
        bottom: 16,
        left: 50,
        right: 50,
        textAlign: 'left'
    },
    pageBreakPadding: {
        height: 26,
        width: '100%'
    },
    lightDivider: {
        borderTop: '0.5 solid #000000',
        marginTop: 10,
        marginBottom: 10
    }
});
const Row = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.row,
        ...props
    });
const Col = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.col,
        ...props
    });
const Box = ({ mt, mb, ...props })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            styles.box,
            {
                marginTop: mt,
                marginBottom: mb
            }
        ],
        ...props
    });
const Signature = ({ text, fontSize = 12, lineThickness = 1 })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.signature
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: {
            ...styles.signatureText,
            fontSize: fontSize
        }
    }, text, ":"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            ...styles.line,
            borderBottomWidth: lineThickness
        }
    }));
const SigningImage = ({ src })=>/*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: src,
        style: styles.signingImage,
        cache: false
    });
const Watermark = ({ src })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.watermarkContainer
    }, /*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: src,
        style: styles.watermarkImage,
        cache: false
    }));
const Logo = ({ logoSrc })=>/*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: logoSrc,
        style: styles.logo,
        cache: false
    });
const VDSImage = ({ src })=>/*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: src,
        style: styles.vds
    });
const CertificateLogo = ({ logoSrc })=>/*#__PURE__*/ _react.default.createElement(_renderer.Image, {
        src: logoSrc,
        style: styles.certificateLogo,
        cache: false
    });
const CertificateHeader = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.certificateHeader,
        ...props
    });
const CertificateFooter = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.certificateFooter,
        ...props
    });
const LightDivider = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.lightDivider,
        ...props
    });
const CertificateContent = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: styles.certificateContent,
        ...props
    });
const FixedHeader = ({ children, props })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        style: styles.fixedHeader,
        ...props
    }, children);
const FixedFooter = ({ children, props })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        style: styles.fixedFooter,
        ...props
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            ...styles.lightDivider,
            borderTopColor: '#888888'
        }
    }), children);
const PageBreakPadding = ({ size })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true,
        style: {
            ...styles.pageBreakPadding,
            height: size || styles.pageBreakPadding.height
        }
    });

//# sourceMappingURL=Layout.js.map