"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    buildToken: function() {
        return buildToken;
    },
    findUserById: function() {
        return findUserById;
    },
    getRandomBase64String: function() {
        return getRandomBase64String;
    },
    getRandomU32: function() {
        return getRandomU32;
    },
    isInternalClient: function() {
        return isInternalClient;
    },
    stripUser: function() {
        return stripUser;
    },
    verifyToken: function() {
        return verifyToken;
    }
});
const _nodecrypto = require("node:crypto");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _jose = /*#__PURE__*/ _interop_require_wildcard(require("jose"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const MAX_U32_VALUE = 2 ** 32 - 1;
const stripUser = (user)=>{
    const userData = {
        ...user
    };
    delete userData.password;
    return userData;
};
const buildToken = async (data, secret, options)=>{
    if (!secret) {
        secret = _config.default.auth.secret ?? crypto.randomUUID();
    }
    if (typeof secret === 'string') {
        secret = (0, _nodecrypto.createSecretKey)(new TextEncoder().encode(secret));
    }
    return await new _jose.SignJWT(data).setProtectedHeader({
        alg: _constants.JWT_KEY_ALG,
        kid: _constants.JWT_KEY_ID
    }).setJti((0, _nodecrypto.randomBytes)(32).toString('base64url')).setIssuedAt().setIssuer(options.issuer).setAudience(options.audience).setExpirationTime(options.expiresIn).sign(secret);
};
const getRandomBase64String = async (length, encoding = 'base64')=>{
    return new Promise((resolve, reject)=>{
        (0, _nodecrypto.randomBytes)(length, (err, buf)=>{
            if (err) reject(err);
            resolve(buf.toString(encoding));
        });
    });
};
const getRandomU32 = ()=>{
    return (0, _nodecrypto.randomInt)(0, MAX_U32_VALUE);
};
const verifyToken = async (token, tokenSecret, options)=>{
    const secret = (0, _nodecrypto.createSecretKey)(new TextEncoder().encode(tokenSecret));
    return await _jose.jwtVerify(token, secret, options);
};
const findUserById = async (models, id)=>{
    const user = await models.User.findByPk(id);
    if (!user) {
        return null;
    }
    return user.get({
        plain: true
    });
};
const isInternalClient = (client)=>Object.values(_constants.SERVER_TYPES).includes(client);

//# sourceMappingURL=utils.js.map