"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "loadSignerCommand", {
    enumerable: true,
    get: function() {
        return loadSignerCommand;
    }
});
const _fs = require("fs");
const _datefns = require("date-fns");
const _commander = require("commander");
const _logging = require("@tamanu/shared/services/logging");
const _database = require("@tamanu/database");
const _Signer = require("../integrations/Signer");
const _database1 = require("../database");
async function loadSigner({ signerCertificate }) {
    await (0, _database1.initDatabase)({
        testMode: false
    });
    const signerFile = await _fs.promises.readFile(signerCertificate, 'utf8');
    const signerData = await (0, _Signer.loadCertificateIntoSigner)(signerFile);
    const pending = await _database.Signer.findPending();
    if (!pending) {
        throw new Error('No pending signer, did you do this already?');
    }
    await pending.update(signerData);
    const start = (0, _datefns.format)(signerData.workingPeriodStart, 'yyyy-MM-dd');
    const end = (0, _datefns.format)(signerData.workingPeriodEnd, 'yyyy-MM-dd');
    _logging.log.info(`Loaded Signer (${start} - ${end})`);
    process.exit(0);
}
const loadSignerCommand = new _commander.Command('loadSigner').description('Loads an ICAO signer certificate into Tamanu').requiredOption('-s, --signer-certificate <path>', 'Path to the signer certificate').action(loadSigner);

//# sourceMappingURL=loadSigner.js.map