"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ReferenceDataRelation", {
    enumerable: true,
    get: function() {
        return ReferenceDataRelation;
    }
});
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
const _Model = require("./Model");
const REFERENCE_DATA_RELATION_TYPE_VALUES = Object.keys(_constants.REFERENCE_DATA_RELATION_TYPES);
let ReferenceDataRelation = class ReferenceDataRelation extends _Model.Model {
    static initModel(options) {
        super.init({
            id: {
                type: _sequelize.DataTypes.UUID,
                allowNull: false,
                primaryKey: true,
                defaultValue: _sequelize.Sequelize.fn('gen_random_uuid')
            },
            referenceDataId: {
                type: _sequelize.DataTypes.TEXT,
                references: {
                    model: 'reference_data',
                    key: 'id'
                }
            },
            referenceDataParentId: {
                type: _sequelize.DataTypes.TEXT,
                references: {
                    model: 'reference_data',
                    key: 'id'
                }
            },
            type: {
                type: _sequelize.DataTypes.ENUM(...REFERENCE_DATA_RELATION_TYPE_VALUES),
                defaultValue: _constants.REFERENCE_DATA_RELATION_TYPES.ADDRESS_HIERARCHY
            }
        }, {
            ...options,
            syncDirection: _constants.SYNC_DIRECTIONS.BIDIRECTIONAL
        });
    }
    static buildSyncFilter() {
        return null; // syncs everywhere
    }
    static async buildSyncLookupQueryDetails() {
        return null; // syncs everywhere
    }
};

//# sourceMappingURL=ReferenceDataRelation.js.map