import { DataTypes } from 'sequelize';
import { SYNC_DIRECTIONS } from '@tamanu/constants';
import { Model } from './Model';
import { buildSyncLookupSelect } from '../sync/buildSyncLookupSelect';
export class LocationAssignment extends Model {
    static initModel({ primaryKey, ...options }) {
        super.init({
            id: primaryKey,
            date: {
                type: DataTypes.DATESTRING,
                allowNull: false
            },
            startTime: {
                type: DataTypes.TIME,
                allowNull: false
            },
            endTime: {
                type: DataTypes.TIME,
                allowNull: false
            }
        }, {
            ...options,
            syncDirection: SYNC_DIRECTIONS.PULL_FROM_CENTRAL
        });
    }
    static initRelations(models) {
        this.belongsTo(models.LocationAssignmentTemplate, {
            foreignKey: 'templateId',
            as: 'template'
        });
        this.belongsTo(models.User, {
            foreignKey: 'userId',
            as: 'user'
        });
        this.belongsTo(models.Location, {
            foreignKey: 'locationId',
            as: 'location'
        });
    }
    static buildSyncFilter() {
        return `
      LEFT JOIN locations ON ${this.tableName}.location_id = locations.id
      LEFT JOIN location_groups ON locations.location_group_id = location_groups.id
      WHERE COALESCE(location_groups.facility_id, locations.facility_id) IN (:facilityIds)
      AND ${this.tableName}.updated_at_sync_tick > :since
    `;
    }
    static async buildSyncLookupQueryDetails() {
        return {
            select: await buildSyncLookupSelect(this, {
                facilityId: 'COALESCE(location_groups.facility_id, locations.facility_id)'
            }),
            joins: `
        LEFT JOIN locations ON ${this.tableName}.location_id = locations.id
        LEFT JOIN location_groups ON locations.location_group_id = location_groups.id
      `
        };
    }
}

//# sourceMappingURL=LocationAssignment.js.map