"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirAnnotation", {
    enumerable: true,
    get: function() {
        return FhirAnnotation;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _fhir = require("../../utils/fhir");
const _baseType = require("./baseType");
const _reference = require("./reference");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirAnnotation = class FhirAnnotation extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            authorReference: _reference.FhirReference.asYup().nullable().default(null),
            authorString: _yup.string().nullable().default(null),
            time: _yup.string().nullable().default(null),
            text: _yup.string().required(),
            _exclusive: _yup.bool().when([
                'authorReference',
                'authorString'
            ], {
                is: (name, path)=>!!name && !!path,
                then: _yup.bool().required('Only one of authorReference or authorString are allowed, but not both.'),
                otherwise: _yup.bool()
            })
        }).noUnknown();
    }
    static fake(model, { fieldName }, id) {
        return new this({
            authorString: `${model.name}.${fieldName}.author.${id}`,
            time: (0, _fhir.formatFhirDate)(new Date()),
            text: `${model.name}.${fieldName}.text.${id}`
        });
    }
};

//# sourceMappingURL=annotation.js.map