"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "HandoverHeaderSection", {
    enumerable: true,
    get: function() {
        return HandoverHeaderSection;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _getDisplayDate = require("../patientCertificates/getDisplayDate");
const _Layout = require("../patientCertificates/Layout");
const _Typography = require("../patientCertificates/Typography");
const _Divider = require("./Divider");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const HandoverHeaderSection = ({ letterheadConfig, logoSrc, locationGroupName })=>{
    const { title, subTitle } = letterheadConfig;
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, logoSrc && /*#__PURE__*/ _react.default.createElement(_Layout.Logo, {
        logoSrc: logoSrc
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        style: {
            maxWidth: 400,
            marginLeft: 'auto',
            marginRight: '0',
            width: '100%'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Typography.H3, {
        style: {
            textAlign: 'right',
            fontWeight: 700,
            marginBottom: 10
        }
    }, title), /*#__PURE__*/ _react.default.createElement(_Typography.H3, {
        style: {
            textAlign: 'right',
            fontWeight: 'bold'
        }
    }, subTitle), /*#__PURE__*/ _react.default.createElement(_Typography.H1, {
        style: {
            textAlign: 'right',
            fontSize: 18,
            marginBottom: 5,
            marginTop: 0
        }
    }, "Handover notes"), /*#__PURE__*/ _react.default.createElement(_Typography.H1, {
        style: {
            textAlign: 'right',
            fontSize: 17,
            marginTop: 0
        }
    }, locationGroupName, " | ", (0, _getDisplayDate.getDisplayDate)(new Date(), 'dd/MM/yy hh:mm a'))), /*#__PURE__*/ _react.default.createElement(_Divider.Divider, null));
};

//# sourceMappingURL=HandoverHeaderSection.js.map