"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    LAB_REQUEST_FORM_TYPES: function() {
        return LAB_REQUEST_FORM_TYPES;
    },
    LAB_REQUEST_STATUSES: function() {
        return LAB_REQUEST_STATUSES;
    },
    LAB_REQUEST_STATUS_CONFIG: function() {
        return LAB_REQUEST_STATUS_CONFIG;
    },
    LAB_REQUEST_STATUS_LABELS: function() {
        return LAB_REQUEST_STATUS_LABELS;
    },
    LAB_REQUEST_TABLE_STATUS_GROUPINGS: function() {
        return LAB_REQUEST_TABLE_STATUS_GROUPINGS;
    },
    LAB_TEST_RESULT_TYPES: function() {
        return LAB_TEST_RESULT_TYPES;
    },
    LAB_TEST_TYPE_VISIBILITY_STATUSES: function() {
        return LAB_TEST_TYPE_VISIBILITY_STATUSES;
    }
});
const _importable = require("./importable.js");
const _colors = require("./colors.js");
const LAB_REQUEST_STATUSES = {
    RECEPTION_PENDING: 'reception_pending',
    RESULTS_PENDING: 'results_pending',
    INTERIM_RESULTS: 'interim_results',
    TO_BE_VERIFIED: 'to_be_verified',
    VERIFIED: 'verified',
    PUBLISHED: 'published',
    CANCELLED: 'cancelled',
    INVALIDATED: 'invalidated',
    DELETED: 'deleted',
    SAMPLE_NOT_COLLECTED: 'sample-not-collected',
    ENTERED_IN_ERROR: 'entered-in-error'
};
const LAB_REQUEST_STATUS_LABELS = {
    [LAB_REQUEST_STATUSES.RECEPTION_PENDING]: 'Reception pending',
    [LAB_REQUEST_STATUSES.RESULTS_PENDING]: 'Results pending',
    [LAB_REQUEST_STATUSES.INTERIM_RESULTS]: 'Interim results',
    [LAB_REQUEST_STATUSES.TO_BE_VERIFIED]: 'To be verified',
    [LAB_REQUEST_STATUSES.VERIFIED]: 'Verified',
    [LAB_REQUEST_STATUSES.PUBLISHED]: 'Published',
    [LAB_REQUEST_STATUSES.SAMPLE_NOT_COLLECTED]: 'Sample not collected',
    [LAB_REQUEST_STATUSES.CANCELLED]: 'Cancelled',
    [LAB_REQUEST_STATUSES.INVALIDATED]: 'Invalidated',
    [LAB_REQUEST_STATUSES.DELETED]: 'Deleted',
    [LAB_REQUEST_STATUSES.ENTERED_IN_ERROR]: 'Entered in error'
};
const LAB_REQUEST_STATUS_CONFIG = {
    [LAB_REQUEST_STATUSES.RECEPTION_PENDING]: {
        color: _colors.COLORS.pink
    },
    [LAB_REQUEST_STATUSES.RESULTS_PENDING]: {
        color: _colors.COLORS.darkOrange
    },
    [LAB_REQUEST_STATUSES.INTERIM_RESULTS]: {
        color: '#006278'
    },
    [LAB_REQUEST_STATUSES.TO_BE_VERIFIED]: {
        color: _colors.COLORS.metallicYellow
    },
    [LAB_REQUEST_STATUSES.VERIFIED]: {
        color: _colors.COLORS.blue
    },
    [LAB_REQUEST_STATUSES.PUBLISHED]: {
        color: _colors.COLORS.green
    },
    [LAB_REQUEST_STATUSES.SAMPLE_NOT_COLLECTED]: {
        color: _colors.COLORS.purple
    },
    [LAB_REQUEST_STATUSES.CANCELLED]: {
        color: _colors.COLORS.grey
    },
    [LAB_REQUEST_STATUSES.INVALIDATED]: {
        color: _colors.COLORS.grey
    },
    [LAB_REQUEST_STATUSES.DELETED]: {
        color: _colors.COLORS.grey
    },
    [LAB_REQUEST_STATUSES.ENTERED_IN_ERROR]: {
        color: _colors.COLORS.red,
        background: '#FFCEC7'
    },
    unknown: {
        label: 'Unknown',
        color: _colors.COLORS.grey
    }
};
const LAB_TEST_RESULT_TYPES = {
    FREE_TEXT: 'FreeText',
    NUMBER: 'Number',
    SELECT: 'Select'
};
const LAB_REQUEST_FORM_TYPES = {
    PANEL: 'panel',
    INDIVIDUAL: 'individual',
    SUPERSET: 'superset'
};
const LAB_TEST_TYPE_VISIBILITY_STATUSES = {
    ..._importable.VISIBILITY_STATUSES,
    PANEL_ONLY: 'panelOnly'
};
const LAB_REQUEST_TABLE_STATUS_GROUPINGS = {
    ACTIVE: [
        LAB_REQUEST_STATUSES.RECEPTION_PENDING,
        LAB_REQUEST_STATUSES.RESULTS_PENDING,
        LAB_REQUEST_STATUSES.INTERIM_RESULTS,
        LAB_REQUEST_STATUSES.SAMPLE_NOT_COLLECTED,
        LAB_REQUEST_STATUSES.TO_BE_VERIFIED,
        LAB_REQUEST_STATUSES.VERIFIED
    ],
    COMPLETED: [
        LAB_REQUEST_STATUSES.PUBLISHED,
        LAB_REQUEST_STATUSES.INVALIDATED
    ]
};

//# sourceMappingURL=labs.js.map