"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = /*#__PURE__*/ _interop_require_wildcard(require("sequelize"));
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
async function up(query) {
    await query.dropTable('sync_session_records');
}
async function down(query) {
    await query.createTable('sync_session_records', {
        id: {
            type: _sequelize.DataTypes.UUID,
            defaultValue: _sequelize.default.fn('uuid_generate_v4'),
            allowNull: false,
            primaryKey: true
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.default.NOW,
            allowNull: false
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        },
        session_id: {
            type: _sequelize.DataTypes.UUID,
            references: {
                model: 'sync_sessions',
                key: 'id'
            },
            allowNull: false
        },
        direction: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        record_type: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        record_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        is_deleted: {
            type: _sequelize.DataTypes.BOOLEAN,
            allowNull: false
        },
        data: {
            type: _sequelize.DataTypes.JSON,
            allowNull: false
        },
        saved_at_sync_tick: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: false
        },
        updated_at_by_field_sum: {
            type: _sequelize.DataTypes.BIGINT,
            allowNull: true
        }
    });
    await query.sequelize.query(`
    CREATE INDEX sync_session_record_session_id_direction_index ON sync_session_records(session_id, direction);
  `);
}

//# sourceMappingURL=1670204471563-dropSyncSessionRecords.js.map