/** @typedef {import('sequelize').QueryInterface} QueryInterface */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    down: function() {
        return down;
    },
    up: function() {
        return up;
    }
});
const _sequelize = require("sequelize");
async function up(query) {
    await query.removeColumn('invoices', 'payment_status');
    await query.removeColumn('invoices', 'receipt_number');
    await query.createTable('invoice_payments', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoices',
                key: 'id'
            }
        },
        date: {
            type: _sequelize.DataTypes.DATESTRING,
            allowNull: false
        },
        receipt_number: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        amount: {
            type: _sequelize.DataTypes.DECIMAL,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
    await query.createTable('invoice_patient_payments', {
        id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            primaryKey: true,
            defaultValue: _sequelize.Sequelize.fn('uuid_generate_v4')
        },
        invoice_payment_id: {
            type: _sequelize.DataTypes.UUID,
            allowNull: false,
            references: {
                model: 'invoice_payments',
                key: 'id'
            },
            unique: true
        },
        method_id: {
            type: _sequelize.DataTypes.STRING,
            allowNull: false
        },
        created_at: {
            type: _sequelize.DataTypes.DATE,
            defaultValue: _sequelize.Sequelize.fn('now'),
            allowNull: false
        },
        updated_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true,
            defaultValue: _sequelize.DataTypes.NOW
        },
        deleted_at: {
            type: _sequelize.DataTypes.DATE,
            allowNull: true
        }
    });
}
async function down(query) {
    await query.addColumn('invoices', 'payment_status', {
        type: _sequelize.DataTypes.STRING,
        allowNull: false
    });
    await query.addColumn('invoices', 'receipt_number', {
        type: _sequelize.DataTypes.STRING,
        allowNull: true
    });
    await query.dropTable('invoice_patient_payments');
    await query.dropTable('invoice_payments');
}

//# sourceMappingURL=1719225348709-addInvoicePaymentsTable.js.map