"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getQueryOptions", {
    enumerable: true,
    get: function() {
        return getQueryOptions;
    }
});
function getQueryOptions(models) {
    const { Patient, PatientAdditionalData } = models;
    const patientOptions = {
        include: [
            {
                model: PatientAdditionalData,
                as: 'additionalData',
                limit: 1
            }
        ]
    };
    return {
        [Patient.tableName]: patientOptions
    };
}

//# sourceMappingURL=getQueryOptions.js.map