"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "LabTestPanelExporter", {
    enumerable: true,
    get: function() {
        return LabTestPanelExporter;
    }
});
const _DefaultDataExporter = require("./DefaultDataExporter");
let LabTestPanelExporter = class LabTestPanelExporter extends _DefaultDataExporter.DefaultDataExporter {
    async getData() {
        const labTestPanels = await this.models.LabTestPanel.findAll({
            include: [
                {
                    model: this.models.LabTestType,
                    as: 'labTestTypes',
                    attributes: [
                        'id'
                    ],
                    through: {
                        attributes: [
                            'order'
                        ]
                    }
                }
            ],
            order: [
                [
                    'labTestTypes',
                    this.models.LabTestPanelLabTestTypes,
                    'order',
                    'ASC'
                ]
            ]
        });
        return labTestPanels.map(({ dataValues: { labTestTypes, ...rest } })=>({
                ...rest,
                testTypesInPanel: labTestTypes.map(({ id })=>id).join(',')
            }));
    }
    getHeadersFromData(data) {
        return Object.keys(data[0]);
    }
};

//# sourceMappingURL=LabTestPanelExporter.js.map