import React from 'react';
import { StyleSheet, View } from '@react-pdf/renderer';
import { Text } from '../pdf/Text';
const basicBorder = '1 solid black';
const tableStyles = StyleSheet.create({
    tr: {
        flexDirection: 'row',
        flexWrap: 'wrap',
        borderBottom: basicBorder,
        borderTop: basicBorder,
        marginBottom: -1
    },
    th: {
        flex: 1,
        fontSize: 10,
        fontWeight: 700,
        padding: 3,
        borderRight: basicBorder,
        margin: 0
    },
    td: {
        flex: 1,
        padding: 3,
        fontSize: 10,
        margin: 0,
        borderRight: basicBorder
    }
});
const getHiddenRowDividerStyle = (index, rowCount)=>{
    if (index === rowCount - 1) return {
        borderTopWidth: 0
    };
    return {
        borderTopWidth: 0,
        borderBottomWidth: 0
    };
};
const getSectionConfig = (index, data, getRowSectionLabel)=>{
    const sectionLabel = getRowSectionLabel?.(data[index]);
    if (!sectionLabel) return {
        sectionLabel: null,
        shouldRenderSection: false
    };
    const lastSectionLabel = index > 0 ? getRowSectionLabel?.(data[index - 1]) : null;
    return {
        sectionLabel,
        shouldRenderSection: sectionLabel !== lastSectionLabel
    };
};
const TR = ({ style, ...props })=>/*#__PURE__*/ React.createElement(View, {
        ...props,
        style: [
            tableStyles.tr,
            style
        ]
    });
const TH = ({ customStyles, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        bold: true,
        ...props,
        style: [
            tableStyles.th,
            customStyles
        ]
    });
const TD = ({ customStyles, ...props })=>/*#__PURE__*/ React.createElement(Text, {
        wrap: false,
        ...props,
        style: [
            tableStyles.td,
            customStyles
        ]
    });
const SectionRow = ({ label, columnStyle })=>/*#__PURE__*/ React.createElement(TR, {
        style: {
            borderTopWidth: 0
        }
    }, /*#__PURE__*/ React.createElement(TD, {
        customStyles: [
            columnStyle,
            {
                borderLeft: basicBorder
            }
        ],
        bold: true
    }, label));
export const Table = ({ data, columns, getLocalisation, getSetting, columnStyle, headerStyle, hideRowDividers = false, getRowSectionLabel })=>{
    const visibleColumns = columns.filter(({ key })=>getSetting(`fields.${key}.hidden`) !== true);
    return /*#__PURE__*/ React.createElement(View, {
        style: tableStyles.table
    }, /*#__PURE__*/ React.createElement(TR, {
        fixed: true
    }, visibleColumns.map(({ title, key, customStyles }, index)=>/*#__PURE__*/ React.createElement(TH, {
            key: key,
            customStyles: [
                columnStyle,
                headerStyle,
                customStyles,
                index === 0 && {
                    borderLeft: basicBorder
                }
            ]
        }, title))), data.map((row, rowIndex)=>{
        const { sectionLabel, shouldRenderSection } = getSectionConfig(rowIndex, data, getRowSectionLabel);
        return /*#__PURE__*/ React.createElement(React.Fragment, {
            key: rowIndex
        }, shouldRenderSection && /*#__PURE__*/ React.createElement(SectionRow, {
            label: sectionLabel,
            columnStyle: columnStyle
        }), /*#__PURE__*/ React.createElement(TR, {
            style: hideRowDividers && getHiddenRowDividerStyle(rowIndex, data.length)
        }, visibleColumns.map(({ accessor, key, customStyles = {} }, index)=>{
            const isFirstColumn = index === 0;
            return /*#__PURE__*/ React.createElement(TD, {
                key: key,
                customStyles: [
                    columnStyle,
                    customStyles,
                    isFirstColumn && {
                        borderLeft: basicBorder
                    },
                    // Indent the first column if belongs to a section
                    isFirstColumn && sectionLabel && {
                        textIndent: 6
                    }
                ]
            }, accessor ? accessor(row, getLocalisation, getSetting) : row[key]);
        })));
    }));
};

//# sourceMappingURL=Table.js.map