"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getReferenceRange: function() {
        return getReferenceRange;
    },
    getReferenceRangeWithUnit: function() {
        return getReferenceRangeWithUnit;
    }
});
const _constants = require("@tamanu/constants");
const hasValue = (value)=>value || value === 0;
const getReferenceRange = ({ labTestType, sex, getTranslation })=>{
    if (!labTestType) return '';
    const max = sex === _constants.SEX_VALUES.MALE ? labTestType.maleMax : labTestType.femaleMax;
    const min = sex === _constants.SEX_VALUES.MALE ? labTestType.maleMin : labTestType.femaleMin;
    const hasMax = hasValue(max);
    const hasMin = hasValue(min);
    let baseRange;
    if (hasMin && hasMax) baseRange = getTranslation('general.fallback.range', ':min - :max', {
        replacements: {
            min,
            max
        }
    });
    else if (hasMin) baseRange = getTranslation('general.fallback.greaterThan', '>:min', {
        replacements: {
            min
        }
    });
    else if (hasMax) baseRange = getTranslation('general.fallback.lessThan', '<:max', {
        replacements: {
            max
        }
    });
    else if (labTestType.rangeText) baseRange = labTestType.rangeText;
    else baseRange = getTranslation('general.fallback.notApplicable', 'N/A', {
        casing: 'lower'
    });
    return baseRange;
};
const getReferenceRangeWithUnit = ({ labTestType, sex, getTranslation })=>{
    if (!labTestType) return '';
    const referenceRange = getReferenceRange({
        labTestType,
        sex,
        getTranslation
    });
    const { unit } = labTestType;
    if (!unit) return referenceRange;
    if (referenceRange === getTranslation('general.fallback.notApplicable', 'N/A', {
        casing: 'lower'
    })) return referenceRange;
    return `${referenceRange} ${unit}`;
};

//# sourceMappingURL=labTests.js.map