"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "labRequestLog", {
    enumerable: true,
    get: function() {
        return labRequestLog;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const labRequestLog = _express.default.Router();
labRequestLog.get('/labRequest/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('list', 'LabRequestLog');
    const logs = await models.LabRequestLog.findAll({
        where: {
            labRequestId: params.id
        },
        order: [
            [
                'createdAt',
                'DESC'
            ]
        ]
    });
    const logsWithDisplayName = await Promise.all(logs.map(async (log)=>{
        const updatedByDisplayName = (await models.User.findByPk(log.updatedById)).dataValues.displayName;
        return {
            ...log.dataValues,
            updatedByDisplayName
        };
    }));
    res.send({
        count: logsWithDisplayName.length,
        data: logsWithDisplayName
    });
}));
labRequestLog.get('/labRequest/:id/latest-published', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('list', 'LabRequestLog');
    const publishedLog = await models.LabRequestLog.findOne({
        where: {
            labRequestId: params.id,
            status: {
                [_sequelize.Op.in]: [
                    _constants.LAB_REQUEST_STATUSES.PUBLISHED,
                    _constants.LAB_REQUEST_STATUSES.VERIFIED
                ]
            }
        },
        order: [
            [
                'createdAt',
                'DESC'
            ]
        ],
        include: [
            {
                association: 'updatedBy',
                attributes: [
                    'displayName'
                ]
            }
        ]
    });
    res.send(publishedLog);
}));

//# sourceMappingURL=labRequestLog.js.map