"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "MultipleLabRequestsPrintout", {
    enumerable: true,
    get: function() {
        return MultipleLabRequestsPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _proptypes = /*#__PURE__*/ _interop_require_default(require("prop-types"));
const _renderer = require("@react-pdf/renderer");
const _PatientDetailsWithBarcode = require("./printComponents/PatientDetailsWithBarcode");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _Typography = require("./Typography");
const _EncounterDetails = require("./printComponents/EncounterDetails");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _LabRequestDetailsSection = require("./LabRequestDetailsSection");
const _HorizontalRule = require("./printComponents/HorizontalRule");
const _DoubleHorizontalRule = require("./printComponents/DoubleHorizontalRule");
const _Footer = require("./printComponents/Footer");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const textFontSize = 9;
const signingSectionStyles = _renderer.StyleSheet.create({
    underlinedText: {
        textDecoration: 'underline'
    },
    signatureView: {
        paddingRight: 32
    },
    disclaimerText: {
        fontStyle: 'italic',
        fontSize: 8
    }
});
const labDetailsSectionStyles = _renderer.StyleSheet.create({
    divider: {
        borderBottom: '2px solid black',
        marginVertical: '10px'
    },
    detailsContainer: {
        marginBottom: 5
    }
});
const generalStyles = _renderer.StyleSheet.create({
    page: {
        paddingBottom: 50
    },
    container: {
        marginVertical: 6
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestDetailsSection = ({ labRequests })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, "Lab request details"), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), labRequests.map((request, index)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            key: request.id,
            style: labDetailsSectionStyles.detailsContainer
        }, /*#__PURE__*/ _react.default.createElement(_LabRequestDetailsSection.FullLabRequestDetailsSection, {
            request: request
        }), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_LabRequestDetailsSection.SampleDetailsRow, {
            request: request
        }), index < labRequests.length - 1 && /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: labDetailsSectionStyles.divider
        }))), /*#__PURE__*/ _react.default.createElement(_DoubleHorizontalRule.DoubleHorizontalRule, null));
const LabRequestSigningSection = ({ getTranslation })=>{
    const BaseSigningSection = ({ title })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: {
                flexDirection: 'column'
            }
        }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
            bold: true,
            style: signingSectionStyles.underlinedText,
            fontSize: 9
        }, title), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
            style: signingSectionStyles.signatureView
        }, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
            text: "Signed",
            fontSize: textFontSize,
            lineThickness: 0.5
        }), /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
            text: "Date",
            fontSize: textFontSize,
            lineThickness: 0.5
        })));
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(BaseSigningSection, {
        title: getTranslation('general.localisedField.clinician.label', 'Clinician')
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(BaseSigningSection, {
        title: "Patient"
    }), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: signingSectionStyles.disclaimerText
    }, "Patient to sign if required, according to local regulations"))));
};
const MultipleLabRequestsPrintoutComponent = /*#__PURE__*/ _react.default.memo(({ patientData, labRequests, encounter, certificateData, getLocalisation, getTranslation, getSetting })=>{
    const { logo } = certificateData;
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: [
            _Layout.styles.page,
            generalStyles.page
        ]
    }, /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        lts: true,
        certificateTitle: "Lab request"
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_PatientDetailsWithBarcode.PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_EncounterDetails.EncounterDetails, {
        encounter: encounter
    }))), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateContent, null, /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(LabRequestDetailsSection, {
        labRequests: labRequests
    })), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(LabRequestSigningSection, {
        getTranslation: getTranslation,
        labRequests: labRequests
    }))), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
});
const MultipleLabRequestsPrintout = (0, _languageContext.withLanguageContext)(MultipleLabRequestsPrintoutComponent);
MultipleLabRequestsPrintout.propTypes = {
    patientData: _proptypes.default.object.isRequired,
    village: _proptypes.default.object.isRequired,
    encounter: _proptypes.default.object.isRequired,
    labRequests: _proptypes.default.array.isRequired,
    certificateData: _proptypes.default.object.isRequired
};

//# sourceMappingURL=MultipleLabRequestsPrintout.js.map