import React from 'react';
import PropTypes from 'prop-types';
import { Document, StyleSheet, View } from '@react-pdf/renderer';
import { PatientDetailsWithBarcode } from './printComponents/PatientDetailsWithBarcode';
import { styles, CertificateContent, CertificateHeader, Col, Row, Signature } from './Layout';
import { LetterheadSection } from './LetterheadSection';
import { P } from './Typography';
import { EncounterDetails } from './printComponents/EncounterDetails';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { Text } from '../pdf/Text';
import { FullLabRequestDetailsSection, SampleDetailsRow } from './LabRequestDetailsSection';
import { HorizontalRule } from './printComponents/HorizontalRule';
import { DoubleHorizontalRule } from './printComponents/DoubleHorizontalRule';
import { Footer } from './printComponents/Footer';
const textFontSize = 9;
const signingSectionStyles = StyleSheet.create({
    underlinedText: {
        textDecoration: 'underline'
    },
    signatureView: {
        paddingRight: 32
    },
    disclaimerText: {
        fontStyle: 'italic',
        fontSize: 8
    }
});
const labDetailsSectionStyles = StyleSheet.create({
    divider: {
        borderBottom: '2px solid black',
        marginVertical: '10px'
    },
    detailsContainer: {
        marginBottom: 5
    }
});
const generalStyles = StyleSheet.create({
    page: {
        paddingBottom: 50
    },
    container: {
        marginVertical: 6
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: generalStyles.container,
        ...props
    });
const LabRequestDetailsSection = ({ labRequests })=>/*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(P, {
        bold: true,
        fontSize: 11,
        mb: 3
    }, "Lab request details"), /*#__PURE__*/ React.createElement(HorizontalRule, null), labRequests.map((request, index)=>/*#__PURE__*/ React.createElement(View, {
            key: request.id,
            style: labDetailsSectionStyles.detailsContainer
        }, /*#__PURE__*/ React.createElement(FullLabRequestDetailsSection, {
            request: request
        }), /*#__PURE__*/ React.createElement(HorizontalRule, null), /*#__PURE__*/ React.createElement(SampleDetailsRow, {
            request: request
        }), index < labRequests.length - 1 && /*#__PURE__*/ React.createElement(View, {
            style: labDetailsSectionStyles.divider
        }))), /*#__PURE__*/ React.createElement(DoubleHorizontalRule, null));
const LabRequestSigningSection = ({ getTranslation })=>{
    const BaseSigningSection = ({ title })=>/*#__PURE__*/ React.createElement(View, {
            style: {
                flexDirection: 'column'
            }
        }, /*#__PURE__*/ React.createElement(P, {
            bold: true,
            style: signingSectionStyles.underlinedText,
            fontSize: 9
        }, title), /*#__PURE__*/ React.createElement(View, {
            style: signingSectionStyles.signatureView
        }, /*#__PURE__*/ React.createElement(Signature, {
            text: "Signed",
            fontSize: textFontSize,
            lineThickness: 0.5
        }), /*#__PURE__*/ React.createElement(Signature, {
            text: "Date",
            fontSize: textFontSize,
            lineThickness: 0.5
        })));
    return /*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(BaseSigningSection, {
        title: getTranslation('general.localisedField.clinician.label', 'Clinician')
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(BaseSigningSection, {
        title: "Patient"
    }), /*#__PURE__*/ React.createElement(Text, {
        style: signingSectionStyles.disclaimerText
    }, "Patient to sign if required, according to local regulations"))));
};
const MultipleLabRequestsPrintoutComponent = /*#__PURE__*/ React.memo(({ patientData, labRequests, encounter, certificateData, getLocalisation, getTranslation, getSetting })=>{
    const { logo } = certificateData;
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: [
            styles.page,
            generalStyles.page
        ]
    }, /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        lts: true,
        certificateTitle: "Lab request"
    }), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(EncounterDetails, {
        encounter: encounter
    }))), /*#__PURE__*/ React.createElement(CertificateContent, null, /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(LabRequestDetailsSection, {
        labRequests: labRequests
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(LabRequestSigningSection, {
        getTranslation: getTranslation,
        labRequests: labRequests
    }))), /*#__PURE__*/ React.createElement(Footer, null)));
});
export const MultipleLabRequestsPrintout = withLanguageContext(MultipleLabRequestsPrintoutComponent);
MultipleLabRequestsPrintout.propTypes = {
    patientData: PropTypes.object.isRequired,
    village: PropTypes.object.isRequired,
    encounter: PropTypes.object.isRequired,
    labRequests: PropTypes.array.isRequired,
    certificateData: PropTypes.object.isRequired
};

//# sourceMappingURL=MultipleLabRequestsPrintout.js.map