"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getOutstandingSurveys", {
    enumerable: true,
    get: function() {
        return getOutstandingSurveys;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
const _portalSurveyAssignmentschema = require("@tamanu/shared/schemas/patientPortal/responses/portalSurveyAssignment.schema");
const _schemaUtils = require("../../utils/schemaUtils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOutstandingSurveys = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const outstandingSurveys = await models.PortalSurveyAssignment.findAll({
        where: {
            patientId: patient.id,
            status: _constants.PORTAL_SURVEY_ASSIGNMENTS_STATUSES.OUTSTANDING
        },
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema),
        include: [
            {
                model: models.Survey,
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.shape.survey),
                as: 'survey'
            },
            {
                model: models.User,
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.shape.assignedBy),
                as: 'assignedBy'
            }
        ]
    });
    return res.send(outstandingSurveys.map((survey)=>_portalSurveyAssignmentschema.PortalSurveyAssignmentSchema.parse(survey.forResponse())));
});

//# sourceMappingURL=outstandingSurveys.js.map