"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "loadSettingFile", {
    enumerable: true,
    get: function() {
        return loadSettingFile;
    }
});
const _fs = require("fs");
const _json5 = /*#__PURE__*/ _interop_require_default(require("json5"));
const _json = require("@bgotink/kdl/json");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function loadSettingFile(filepath) {
    const file = (await _fs.promises.readFile(filepath)).toString();
    let value;
    if (filepath.endsWith('.json')) {
        value = JSON.parse(file);
    } else if (filepath.endsWith('.json5')) {
        value = _json5.default.parse(file);
    } else if (filepath.endsWith('.kdl')) {
        value = (0, _json.parse)(file);
    } else {
        throw new Error('File format not supported');
    }
    return value;
}

//# sourceMappingURL=loadSettingFile.js.map